<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUniveristyFinancials is autogenerate by UniModel generator
 *
 * This is the model class for table "univeristy_financials".
 *
 * The followings are the available columns in table 'univeristy_financials':
 * @property string $univeristy_financials_id
 * @property integer $uni_ref_id
 * @property integer $course_level_ref_id
 * @property string $fee_type
 * @property string $course_name
 * @property integer $currency_ref_id
 * @property string $fees
 * @property integer $fees_duration
 * @property integer $added_by
 * @property string $added_on
 * @property integer $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property TblAdmin $addedBy
 * @property LookupCourseLevel $courseLevelRef
 * @property LookupCurrency $currencyRef
 * @property TblAdmin $modifiedBy
 * @property TblUniversityMaster $uniRef
 */
class BaseUniveristyFinancials extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UniveristyFinancials the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'univeristy_financials';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_ref_id, course_level_ref_id, fees', 'required'),
			array('uni_ref_id, course_level_ref_id, currency_ref_id, fees_duration, added_by, modified_by', 'numerical', 'integerOnly'=>true),
			array('fee_type', 'length', 'max'=>8),
			array('course_name', 'length', 'max'=>255),
			array('fees', 'length', 'max'=>10),
			array('added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('univeristy_financials_id, uni_ref_id, course_level_ref_id, fee_type, course_name, currency_ref_id, fees, fees_duration, added_by, added_on, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'TblAdmin', 'added_by'),
			'courseLevelRef' => array(self::BELONGS_TO, 'LookupCourseLevel', 'course_level_ref_id'),
			'currencyRef' => array(self::BELONGS_TO, 'LookupCurrency', 'currency_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'TblAdmin', 'modified_by'),
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'univeristy_financials_id' => 'Univeristy Financials',
			'uni_ref_id' => 'Uni Ref',
			'course_level_ref_id' => 'Course Level Ref',
			'fee_type' => 'Fee Type',
			'course_name' => 'Course Name',
			'currency_ref_id' => 'Currency Ref',
			'fees' => 'Fees',
			'fees_duration' => 'Fees Duration',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('univeristy_financials_id',$this->univeristy_financials_id,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('course_level_ref_id',$this->course_level_ref_id);
		$criteria->compare('fee_type',$this->fee_type,true);
		$criteria->compare('course_name',$this->course_name,true);
		$criteria->compare('currency_ref_id',$this->currency_ref_id);
		$criteria->compare('fees',$this->fees,true);
		$criteria->compare('fees_duration',$this->fees_duration);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_by',$this->modified_by);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}