<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUniFacilities is autogenerate by UniModel generator
 *
 * This is the model class for table "uni_facilities".
 *
 * The followings are the available columns in table 'uni_facilities':
 * @property string $uni_facilities_id
 * @property integer $uni_ref_id
 * @property string $facilities
 * @property string $is_active
 * @property integer $added_by
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUniversityMaster $uniRef
 * @property TblAdmin $addedBy
 */
class BaseUniFacilities extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UniFacilities the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'uni_facilities';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_ref_id, added_by', 'numerical', 'integerOnly'=>true),
			array('facilities', 'length', 'max'=>12),
			array('is_active', 'length', 'max'=>1),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('uni_facilities_id, uni_ref_id, facilities, is_active, added_by, added_on,description', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'TblAdmin', 'added_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'uni_facilities_id' => 'Uni Facilities',
			'uni_ref_id' => 'Uni Ref',
			'facilities' => 'Facilities',
			'is_active' => 'Is Active',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
                        'description'=>'Description'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('uni_facilities_id',$this->uni_facilities_id,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('facilities',$this->facilities,true);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}