<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUmailReviewMessageLog is autogenerate by UniModel generator
 *
 * This is the model class for table "umail_review_message_log".
 *
 * The followings are the available columns in table 'umail_review_message_log':
 * @property string $umail_review_message_log_id
 * @property integer $message_ref_id
 * @property string $message
 * @property string $subject
 * @property string $status
 * @property integer $added_by
 * @property string $added_on
 */
class BaseUmailReviewMessageLog extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UmailReviewMessageLog the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'umail_review_message_log';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('message_ref_id, message, status, added_by, added_on', 'required'),
			array('message_ref_id, added_by', 'numerical', 'integerOnly'=>true),
			array('subject', 'length', 'max'=>255),
			array('status', 'length', 'max'=>9),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('umail_review_message_log_id, message_ref_id, message, subject, status, added_by, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'umail_review_message_log_id' => 'Umail Review Message Log',
			'message_ref_id' => 'Message Ref',
			'message' => 'Message',
			'subject' => 'Subject',
			'status' => 'Status',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('umail_review_message_log_id',$this->umail_review_message_log_id,true);
		$criteria->compare('message_ref_id',$this->message_ref_id);
		$criteria->compare('message',$this->message,true);
		$criteria->compare('subject',$this->subject,true);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}