<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUmailRecipient is autogenerate by UniModel generator
 *
 * This is the model class for table "umail_recipient".
 *
 * The followings are the available columns in table 'umail_recipient':
 * @property string $umail_recipient_id
 * @property integer $umail_message_ref_id
 * @property string $recipient_type
 * @property string $email_address
 * @property string $recipient_name
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property UmailMessage $umailMessageRef
 */
class BaseUmailRecipient extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UmailRecipient the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'umail_recipient';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('umail_message_ref_id', 'required'),
			array('umail_message_ref_id', 'numerical', 'integerOnly'=>true),
			array('recipient_type', 'length', 'max'=>7),
			array('email_address', 'length', 'max'=>255),
			array('recipient_name', 'length', 'max'=>100),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('umail_recipient_id, umail_message_ref_id, recipient_type, email_address, recipient_name, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'umailMessageRef' => array(self::BELONGS_TO, 'UmailMessage', 'umail_message_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'umail_recipient_id' => 'Umail Recipient',
			'umail_message_ref_id' => 'Umail Message Ref',
			'recipient_type' => 'Recipient Type',
			'email_address' => 'Email Address',
			'recipient_name' => 'Recipient Name',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('umail_recipient_id',$this->umail_recipient_id,true);
		$criteria->compare('umail_message_ref_id',$this->umail_message_ref_id);
		$criteria->compare('recipient_type',$this->recipient_type,true);
		$criteria->compare('email_address',$this->email_address,true);
		$criteria->compare('recipient_name',$this->recipient_name,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}