<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUmailMessage is autogenerate by UniModel generator
 *
 * This is the model class for table "umail_message".
 *
 * The followings are the available columns in table 'umail_message':
 * @property integer $message_id
 * @property integer $header_ref_id
 * @property integer $sender_type
 * @property integer $sender_id
 * @property integer $recipient_type
 * @property integer $recipient_id
 * @property string $expected_reply_date
 * @property string $actual_reply_date
 * @property integer $message_ref_id
 * @property string $added_on
 * @property string $message
 * @property string $subject
 * @property integer $modified_by
 * @property string $modified_on
 * @property string $interaction_text
 * @property string $status
 *
 * The followings are the available model relations:
 * @property MessageRating[] $messageRatings
 * @property UmailAttachment[] $umailAttachments
 * @property UmailExtensionLog[] $umailExtensionLogs
 * @property UmailHelpLog[] $umailHelpLogs
 * @property UmailLog[] $umailLogs
 * @property UmailHeader $headerRef
 * @property SenderRecipientType $recipientType
 * @property SenderRecipientType $senderType
 * @property TblAdmin $modifiedBy
 * @property UmailMessageComment[] $umailMessageComments
 * @property UmailRecipient[] $umailRecipients
 * @property UmailReviewMessageLog[] $umailReviewMessageLogs
 */
class BaseUmailMessage extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UmailMessage the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'umail_message';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('header_ref_id, sender_type, sender_id, recipient_type, recipient_id', 'required'),
			array('header_ref_id, sender_type, sender_id, recipient_type, recipient_id, message_ref_id, modified_by', 'numerical', 'integerOnly'=>true),
			array('subject', 'length', 'max'=>255),
			array('status', 'length', 'max'=>9),
			array('expected_reply_date, actual_reply_date, added_on, message, modified_on, interaction_text, workplan_steps, auto_escalate', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('message_id, header_ref_id, sender_type, sender_id, recipient_type, recipient_id, expected_reply_date, actual_reply_date, message_ref_id, added_on, message, subject, modified_by, modified_on, interaction_text, status', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'messageRatings' => array(self::HAS_MANY, 'MessageRating', 'message_id'),
			'umailAttachments' => array(self::HAS_MANY, 'UmailAttachment', 'message_id'),
			'umailExtensionLogs' => array(self::HAS_MANY, 'UmailExtensionLog', 'message_ref_id'),
			'umailHelpLogs' => array(self::HAS_MANY, 'UmailHelpLog', 'message_ref_id'),
			'umailLogs' => array(self::HAS_MANY, 'UmailLog', 'message_ref_id'),
			'headerRef' => array(self::BELONGS_TO, 'UmailHeader', 'header_ref_id'),
			'recipientType' => array(self::BELONGS_TO, 'SenderRecipientType', 'recipient_type'),
			'senderType' => array(self::BELONGS_TO, 'SenderRecipientType', 'sender_type'),
			'modifiedBy' => array(self::BELONGS_TO, 'TblAdmin', 'modified_by'),
			'umailMessageComments' => array(self::HAS_MANY, 'UmailMessageComment', 'message_ref_id'),
			'umailRecipients' => array(self::HAS_MANY, 'UmailRecipient', 'umail_message_ref_id'),
			'umailReviewMessageLogs' => array(self::HAS_MANY, 'UmailReviewMessageLog', 'message_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'message_id' => 'Message',
			'header_ref_id' => 'Header Ref',
			'sender_type' => 'Sender Type',
			'sender_id' => 'Sender',
			'recipient_type' => 'Recipient Type',
			'recipient_id' => 'Recipient',
			'expected_reply_date' => 'Expected Reply Date',
			'actual_reply_date' => 'Actual Reply Date',
			'message_ref_id' => 'Message Ref',
			'added_on' => 'Added On',
			'message' => 'Message',
			'subject' => 'Subject',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
			'interaction_text' => 'Interaction Text',
			'status' => 'Status',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('message_id',$this->message_id);
		$criteria->compare('header_ref_id',$this->header_ref_id);
		$criteria->compare('sender_type',$this->sender_type);
		$criteria->compare('sender_id',$this->sender_id);
		$criteria->compare('recipient_type',$this->recipient_type);
		$criteria->compare('recipient_id',$this->recipient_id);
		$criteria->compare('expected_reply_date',$this->expected_reply_date,true);
		$criteria->compare('actual_reply_date',$this->actual_reply_date,true);
		$criteria->compare('message_ref_id',$this->message_ref_id);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('message',$this->message,true);
		$criteria->compare('subject',$this->subject,true);
		$criteria->compare('modified_by',$this->modified_by);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('interaction_text',$this->interaction_text,true);
		$criteria->compare('status',$this->status,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}