<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUmailGuidememailDetail is autogenerate by UniModel generator
 *
 * This is the model class for table "umail_guidememail_detail".
 *
 * The followings are the available columns in table 'umail_guidememail_detail':
 * @property integer $umail_guideme_id
 * @property string $from_email_id
 * @property integer $gmail_unique_id
 * @property integer $header_ref_id
 * @property string $from_date
 */
class BaseUmailGuidememailDetail extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UmailGuidememailDetail the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'umail_guidememail_detail';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('gmail_unique_id, header_ref_id', 'numerical', 'integerOnly'=>true),
			array('from_email_id', 'length', 'max'=>255),
			array('from_date', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('umail_guideme_id, from_email_id, gmail_unique_id, header_ref_id, from_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'umail_guideme_id' => 'Umail Guideme',
			'from_email_id' => 'From Email',
			'gmail_unique_id' => 'Gmail Unique',
			'header_ref_id' => 'Header Ref',
			'from_date' => 'From Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('umail_guideme_id',$this->umail_guideme_id);
		$criteria->compare('from_email_id',$this->from_email_id,true);
		$criteria->compare('gmail_unique_id',$this->gmail_unique_id);
		$criteria->compare('header_ref_id',$this->header_ref_id);
		$criteria->compare('from_date',$this->from_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}