<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTrainingModuleSlidePhotoCaption is autogenerate by UniModel generator
 *
 * This is the model class for table "training_module_slide_photo_caption".
 *
 * The followings are the available columns in table 'training_module_slide_photo_caption':
 * @property string $training_module_slide_photo_caption_id
 * @property string $training_module_slide_ref_id
 * @property string $title
 * @property string $description
 * @property string $attachment_ref_id
 * @property string $caption
 * @property string $added_by
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TrainingModuleSlide $trainingModuleSlideRef
 * @property LoginMaster $addedBy
 */
class BaseTrainingModuleSlidePhotoCaption extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TrainingModuleSlidePhotoCaption the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'training_module_slide_photo_caption';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('training_module_slide_ref_id, title', 'required'),
			array('training_module_slide_ref_id, attachment_ref_id, added_by', 'length', 'max'=>10),
			array('title, description, caption', 'length', 'max'=>255),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('training_module_slide_photo_caption_id, training_module_slide_ref_id, title, description, attachment_ref_id, caption, added_by, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'trainingModuleSlideRef' => array(self::BELONGS_TO, 'TrainingModuleSlide', 'training_module_slide_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'training_module_slide_photo_caption_id' => 'Training Module Slide Photo Caption',
			'training_module_slide_ref_id' => 'Training Module Slide Ref',
			'title' => 'Title',
			'description' => 'Description',
			'attachment_ref_id' => 'Attachment Ref',
			'caption' => 'Caption',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('training_module_slide_photo_caption_id',$this->training_module_slide_photo_caption_id,true);
		$criteria->compare('training_module_slide_ref_id',$this->training_module_slide_ref_id,true);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('attachment_ref_id',$this->attachment_ref_id,true);
		$criteria->compare('caption',$this->caption,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}