<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTblUniPicturesVideos is autogenerate by UniModel generator
 *
 * This is the model class for table "tbl_uni_pictures_videos".
 *
 * The followings are the available columns in table 'tbl_uni_pictures_videos':
 * @property integer $id
 * @property integer $uni_ref_id
 * @property string $uni_image
 * @property string $uni_image_title
 * @property string $website_url
 * @property string $video_embeded_code
 * @property string $type
 * @property string $is_active
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 *
 * The followings are the available model relations:
 * @property TblUniversityMaster $uniRef
 */
class BaseTblUniPicturesVideos extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TblUniPicturesVideos the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_uni_pictures_videos';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_ref_id', 'required'),
			array('uni_ref_id', 'numerical', 'integerOnly'=>true),
			array('type', 'length', 'max'=>5),
			array('is_active', 'length', 'max'=>1),
			array('added_by, modified_on, modified_by', 'length', 'max'=>100),
			array('uni_image, uni_image_title, website_url, video_embeded_code, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, uni_ref_id, uni_image, uni_image_title, website_url, video_embeded_code, type, is_active, added_on, added_by, modified_on, modified_by,uni_image_tag', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'uni_ref_id' => 'Uni Ref',
			'uni_image' => 'Uni Image',
			'uni_image_title' => 'Uni Image Title',
			'website_url' => 'Website Url',
			'video_embeded_code' => 'Video Embeded Code',
			'type' => 'Type',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
			'uni_image_tag' => 'Image Tag',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('uni_image',$this->uni_image,true);
		$criteria->compare('uni_image_title',$this->uni_image_title,true);
		$criteria->compare('website_url',$this->website_url,true);
		$criteria->compare('video_embeded_code',$this->video_embeded_code,true);
		$criteria->compare('type',$this->type,true);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}