<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTblSiBoard is autogenerate by UniModel generator
 *
 * This is the model class for table "tbl_si_board".
 *
 * The followings are the available columns in table 'tbl_si_board':
 * @property integer $si_board_id
 * @property integer $si_ref_id
 * @property integer $board_ref_id
 *
 * The followings are the available model relations:
 * @property LookupBoard $boardRef
 * @property TblSiDi $siRef
 */
class BaseTblSiBoard extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TblSiBoard the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_si_board';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('si_ref_id, board_ref_id', 'required'),
			array('si_ref_id, board_ref_id', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('si_board_id, si_ref_id, board_ref_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'boardRef' => array(self::BELONGS_TO, 'LookupBoard', 'board_ref_id'),
			'siRef' => array(self::BELONGS_TO, 'TblSiDi', 'si_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'si_board_id' => 'Si Board',
			'si_ref_id' => 'Si Ref',
			'board_ref_id' => 'Board Ref',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('si_board_id',$this->si_board_id);
		$criteria->compare('si_ref_id',$this->si_ref_id);
		$criteria->compare('board_ref_id',$this->board_ref_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}