<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTblProfileScore is autogenerate by UniModel generator
 *
 * This is the model class for table "tbl_profile_score".
 *
 * The followings are the available columns in table 'tbl_profile_score':
 * @property string $profile_score_id
 * @property string $field_name
 * @property integer $score_level
 * @property string $field_type
 * @property string $weightage
 * @property string $reference_table
 * @property string $reference_field
 * @property string $is_active
 * @property string $added_on
 */
class BaseTblProfileScore extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TblProfileScore the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_profile_score';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('score_level', 'numerical', 'integerOnly'=>true),
			array('field_name, reference_table, reference_field', 'length', 'max'=>100),
			array('field_type', 'length', 'max'=>9),
			array('weightage', 'length', 'max'=>4),
			array('is_active', 'length', 'max'=>1),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('profile_score_id, field_name, score_level, field_type, weightage, reference_table, reference_field, is_active, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'profile_score_id' => 'Profile Score',
			'field_name' => 'Field Name',
			'score_level' => 'Score Level',
			'field_type' => 'Field Type',
			'weightage' => 'Weightage',
			'reference_table' => 'Reference Table',
			'reference_field' => 'Reference Field',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('profile_score_id',$this->profile_score_id,true);
		$criteria->compare('field_name',$this->field_name,true);
		$criteria->compare('score_level',$this->score_level);
		$criteria->compare('field_type',$this->field_type,true);
		$criteria->compare('weightage',$this->weightage,true);
		$criteria->compare('reference_table',$this->reference_table,true);
		$criteria->compare('reference_field',$this->reference_field,true);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}