<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTblOnlineTest is autogenerate by UniModel generator
 *
 * This is the model class for table "tbl_online_test".
 *
 * The followings are the available columns in table 'tbl_online_test':
 * @property string $online_test_id
 * @property integer $vendor_ref_id
 * @property integer $product_ref_id
 * @property integer $entrance_ref_id
 * @property string $test_title
 * @property string $title_slug
 * @property string $instructions
 * @property integer $study_meterial
 * @property integer $videos
 * @property integer $tests
 * @property integer $quizzes
 * @property integer $currency_ref_id
 * @property integer $orginal_price
 * @property integer $avilable_price
 * @property string $about_course
 * @property string $why_purchase
 * @property string $how_it_works
 * @property string $image_path
 * @property string $logo_path
 * @property string $rating
 * @property integer $validity
 * @property string $validity_type
 * @property string $is_active
 * @property string $added_on
 * @property string $added_by
 *
 * The followings are the available model relations:
 * @property OnlineTestCode[] $onlineTestCodes
 * @property LookupCurrency $currencyRef
 * @property LoginMaster $addedBy
 * @property EntranceExam $entranceRef
 * @property LookupProduct $productRef
 * @property Vendor $vendorRef
 */
class BaseTblOnlineTest extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TblOnlineTest the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_online_test';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('vendor_ref_id, product_ref_id, entrance_ref_id, study_meterial, videos, tests, quizzes, currency_ref_id, orginal_price, avilable_price, validity', 'numerical', 'integerOnly'=>true),
			array('test_title, title_slug', 'length', 'max'=>250),
			array('image_path, logo_path', 'length', 'max'=>150),
			array('rating, is_active', 'length', 'max'=>1),
			array('validity_type', 'length', 'max'=>6),
			array('added_by', 'length', 'max'=>10),
			array('instructions, about_course, why_purchase, how_it_works, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('online_test_id, vendor_ref_id, product_ref_id, entrance_ref_id, test_title, title_slug, instructions, study_meterial, videos, tests, quizzes, currency_ref_id, orginal_price, avilable_price, about_course, why_purchase, how_it_works, image_path, logo_path, rating, validity, validity_type, is_active, added_on, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'onlineTestCodes' => array(self::HAS_MANY, 'OnlineTestCode', 'online_test_ref_id'),
			'currencyRef' => array(self::BELONGS_TO, 'LookupCurrency', 'currency_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'entranceRef' => array(self::BELONGS_TO, 'EntranceExam', 'entrance_ref_id'),
			'productRef' => array(self::BELONGS_TO, 'LookupProduct', 'product_ref_id'),
			'vendorRef' => array(self::BELONGS_TO, 'Vendor', 'vendor_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'online_test_id' => 'Online Test',
			'vendor_ref_id' => 'Vendor Ref',
			'product_ref_id' => 'Product Ref',
			'entrance_ref_id' => 'Entrance Ref',
			'test_title' => 'Test Title',
			'title_slug' => 'Title Slug',
			'instructions' => 'Instructions',
			'study_meterial' => 'Study Meterial',
			'videos' => 'Videos',
			'tests' => 'Tests',
			'quizzes' => 'Quizzes',
			'currency_ref_id' => 'Currency Ref',
			'orginal_price' => 'Orginal Price',
			'avilable_price' => 'Avilable Price',
			'about_course' => 'About Course',
			'why_purchase' => 'Why Purchase',
			'how_it_works' => 'How It Works',
			'image_path' => 'Image Path',
			'logo_path' => 'Logo Path',
			'rating' => 'Rating',
			'validity' => 'Validity',
			'validity_type' => 'Validity Type',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('online_test_id',$this->online_test_id,true);
		$criteria->compare('vendor_ref_id',$this->vendor_ref_id);
		$criteria->compare('product_ref_id',$this->product_ref_id);
		$criteria->compare('entrance_ref_id',$this->entrance_ref_id);
		$criteria->compare('test_title',$this->test_title,true);
		$criteria->compare('title_slug',$this->title_slug,true);
		$criteria->compare('instructions',$this->instructions,true);
		$criteria->compare('study_meterial',$this->study_meterial);
		$criteria->compare('videos',$this->videos);
		$criteria->compare('tests',$this->tests);
		$criteria->compare('quizzes',$this->quizzes);
		$criteria->compare('currency_ref_id',$this->currency_ref_id);
		$criteria->compare('orginal_price',$this->orginal_price);
		$criteria->compare('avilable_price',$this->avilable_price);
		$criteria->compare('about_course',$this->about_course,true);
		$criteria->compare('why_purchase',$this->why_purchase,true);
		$criteria->compare('how_it_works',$this->how_it_works,true);
		$criteria->compare('image_path',$this->image_path,true);
		$criteria->compare('logo_path',$this->logo_path,true);
		$criteria->compare('rating',$this->rating,true);
		$criteria->compare('validity',$this->validity);
		$criteria->compare('validity_type',$this->validity_type,true);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}