<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTblEvent is autogenerate by UniModel generator
 *
 * This is the model class for table "tbl_event".
 *
 * The followings are the available columns in table 'tbl_event':
 * @property integer $event_id
 * @property string $webinar_key
 * @property string $event_title
 * @property string $event_type
 * @property string $event_start_time
 * @property string $event_end_time
 * @property string $timezone
 * @property string $event_desc
 * @property string $speaker_name
 * @property string $speaker_name_visible
 * @property string $speaker_designation
 * @property string $speaker_desig_visible
 * @property string $speaker_org
 * @property string $speaker_org_visible
 * @property string $event_video_url
 * @property string $is_active
 *
 * The followings are the available model relations:
 * @property TblEmailEvents[] $tblEmailEvents
 * @property TblEventAttendees[] $tblEventAttendees
 * @property TblEventComments[] $tblEventComments
 * @property TblEventStudents[] $tblEventStudents
 * @property TblEventsCountries[] $tblEventsCountries
 * @property TblEventsDepartments[] $tblEventsDepartments
 */
class BaseTblEvent extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TblEvent the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_event';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('webinar_key, timezone, speaker_name', 'length', 'max'=>100),
			array('event_title', 'length', 'max'=>255),
			array('event_type', 'length', 'max'=>7),
			array('speaker_name_visible, speaker_desig_visible, speaker_org_visible, is_active', 'length', 'max'=>1),
			array('speaker_designation, speaker_org', 'length', 'max'=>64),
			array('event_start_time, event_end_time, event_desc, event_video_url', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('event_id, webinar_key, event_title, event_type, event_start_time, event_end_time, timezone, event_desc, speaker_name, speaker_name_visible, speaker_designation, speaker_desig_visible, speaker_org, speaker_org_visible, event_video_url, is_active', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'tblEmailEvents' => array(self::HAS_MANY, 'TblEmailEvents', 'event_ref_id'),
			'tblEventAttendees' => array(self::HAS_MANY, 'TblEventAttendees', 'event_ref_id'),
			'tblEventComments' => array(self::HAS_MANY, 'TblEventComments', 'event_ref_id'),
			'tblEventStudents' => array(self::HAS_MANY, 'TblEventStudents', 'event_ref_id'),
			'tblEventsCountries' => array(self::HAS_MANY, 'TblEventsCountries', 'event_ref_id'),
			'tblEventsDepartments' => array(self::HAS_MANY, 'TblEventsDepartments', 'event_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'event_id' => 'Event',
			'webinar_key' => 'Webinar Key',
			'event_title' => 'Event Title',
			'event_type' => 'Event Type',
			'event_start_time' => 'Event Start Time',
			'event_end_time' => 'Event End Time',
			'timezone' => 'Timezone',
			'event_desc' => 'Event Desc',
			'speaker_name' => 'Speaker Name',
			'speaker_name_visible' => 'Speaker Name Visible',
			'speaker_designation' => 'Speaker Designation',
			'speaker_desig_visible' => 'Speaker Desig Visible',
			'speaker_org' => 'Speaker Org',
			'speaker_org_visible' => 'Speaker Org Visible',
			'event_video_url' => 'Event Video Url',
			'is_active' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('event_id',$this->event_id);
		$criteria->compare('webinar_key',$this->webinar_key,true);
		$criteria->compare('event_title',$this->event_title,true);
		$criteria->compare('event_type',$this->event_type,true);
		$criteria->compare('event_start_time',$this->event_start_time,true);
		$criteria->compare('event_end_time',$this->event_end_time,true);
		$criteria->compare('timezone',$this->timezone,true);
		$criteria->compare('event_desc',$this->event_desc,true);
		$criteria->compare('speaker_name',$this->speaker_name,true);
		$criteria->compare('speaker_name_visible',$this->speaker_name_visible,true);
		$criteria->compare('speaker_designation',$this->speaker_designation,true);
		$criteria->compare('speaker_desig_visible',$this->speaker_desig_visible,true);
		$criteria->compare('speaker_org',$this->speaker_org,true);
		$criteria->compare('speaker_org_visible',$this->speaker_org_visible,true);
		$criteria->compare('event_video_url',$this->event_video_url,true);
		$criteria->compare('is_active',$this->is_active,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}