<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTblAdminModuleAccess is autogenerate by UniModel generator
 *
 * This is the model class for table "tbl_admin_module_access".
 *
 * The followings are the available columns in table 'tbl_admin_module_access':
 * @property integer $access_id
 * @property integer $admin_ref_id
 * @property integer $module_ref_id
 * @property string $per_add
 * @property string $per_edit
 * @property string $per_del
 * @property string $per_view
 * @property string $is_active
 * @property string $added_on
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property TblAdmin $adminRef
 * @property TblAdminModule $moduleRef
 */
class BaseTblAdminModuleAccess extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TblAdminModuleAccess the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_admin_module_access';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('admin_ref_id, module_ref_id', 'required'),
			array('admin_ref_id, module_ref_id', 'numerical', 'integerOnly'=>true),
			array('per_add, per_edit, per_del, per_view, is_active', 'length', 'max'=>1),
			array('added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('access_id, admin_ref_id, module_ref_id, per_add, per_edit, per_del, per_view, is_active, added_on, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'adminRef' => array(self::BELONGS_TO, 'TblAdmin', 'admin_ref_id'),
			'moduleRef' => array(self::BELONGS_TO, 'TblAdminModule', 'module_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'access_id' => 'Access',
			'admin_ref_id' => 'Admin Ref',
			'module_ref_id' => 'Module Ref',
			'per_add' => 'Per Add',
			'per_edit' => 'Per Edit',
			'per_del' => 'Per Del',
			'per_view' => 'Per View',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('access_id',$this->access_id);
		$criteria->compare('admin_ref_id',$this->admin_ref_id);
		$criteria->compare('module_ref_id',$this->module_ref_id);
		$criteria->compare('per_add',$this->per_add,true);
		$criteria->compare('per_edit',$this->per_edit,true);
		$criteria->compare('per_del',$this->per_del,true);
		$criteria->compare('per_view',$this->per_view,true);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}