<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTaskStudent is autogenerate by UniModel generator
 *
 * This is the model class for table "task_student".
 *
 * The followings are the available columns in table 'task_student':
 * @property string $task_student_id
 * @property string $task_ref_id
 * @property string $student_ref_id
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster $studentRef
 * @property Task $taskRef
 */
class BaseTaskStudent extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TaskStudent the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'task_student';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('task_ref_id, student_ref_id', 'required'),
			array('task_ref_id, student_ref_id', 'length', 'max'=>10),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('task_student_id, task_ref_id, student_ref_id, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'studentRef' => array(self::BELONGS_TO, 'TblUserMaster', 'student_ref_id'),
			'taskRef' => array(self::BELONGS_TO, 'Task', 'task_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'task_student_id' => 'Task Student',
			'task_ref_id' => 'Task Ref',
			'student_ref_id' => 'Student Ref',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('task_student_id',$this->task_student_id,true);
		$criteria->compare('task_ref_id',$this->task_ref_id,true);
		$criteria->compare('student_ref_id',$this->student_ref_id,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}