<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTagUmail is autogenerate by UniModel generator
 *
 * This is the model class for table "tag_umail".
 *
 * The followings are the available columns in table 'tag_umail':
 * @property string $tag_umail_id
 * @property string $tag
 * @property string $user_ref_id
 * @property string $added_by
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property TblUserMaster $userRef
 */
class BaseTagUmail extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TagUmail the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tag_umail';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, added_by, added_on', 'required'),
			array('tag', 'length', 'max'=>512),
			array('user_ref_id, added_by', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('tag_umail_id, tag, user_ref_id, added_by, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'tag_umail_id' => 'Tag Umail',
			'tag' => 'Tag',
			'user_ref_id' => 'User Ref',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('tag_umail_id',$this->tag_umail_id,true);
		$criteria->compare('tag',$this->tag,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}