<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentWorkplanNotes is autogenerate by UniModel generator
 *
 * This is the model class for table "student_workplan_notes".
 *
 * The followings are the available columns in table 'student_workplan_notes':
 * @property string $student_workplan_notes_id
 * @property string $student_workplan_ref_id
 * @property string $notes
 * @property integer $added_by
 * @property string $added_on
 * @property integer $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property StudentWorkplan $studentWorkplanRef
 * @property TblAdmin $addedBy
 * @property TblAdmin $modifiedBy
 */
class BaseStudentWorkplanNotes extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentWorkplanNotes the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_workplan_notes';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('student_workplan_ref_id, notes, added_by, added_on', 'required'),
			array('added_by, modified_by', 'numerical', 'integerOnly'=>true),
			array('student_workplan_ref_id', 'length', 'max'=>10),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_workplan_notes_id, student_workplan_ref_id, notes, added_by, added_on, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'studentWorkplanRef' => array(self::BELONGS_TO, 'StudentWorkplan', 'student_workplan_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'TblAdmin', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'TblAdmin', 'modified_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_workplan_notes_id' => 'Student Workplan Notes',
			'student_workplan_ref_id' => 'Student Workplan Ref',
			'notes' => 'Notes',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_workplan_notes_id',$this->student_workplan_notes_id,true);
		$criteria->compare('student_workplan_ref_id',$this->student_workplan_ref_id,true);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_by',$this->modified_by);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}