<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentWorkplan is autogenerate by UniModel generator
 *
 * This is the model class for table "student_workplan".
 *
 * The followings are the available columns in table 'student_workplan':
 * @property string $student_workplan_id
 * @property string $parent_ref_id
 * @property string $user_ref_id
 * @property integer $workplan_ref_id
 * @property integer $interaction_ref_id
 * @property string $task_ref_id
 * @property integer $start_date
 * @property integer $start_month
 * @property integer $start_year
 * @property integer $end_date
 * @property integer $end_month
 * @property integer $end_year
 * @property string $description
 * @property string $activity_status
 * @property string $complete_date
 * @property integer $parent_interaction_ref_id
 * @property string $parent_signoff_date
 * @property string $comments
 * @property integer $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property LookupWorkplan $workplanRef
 * @property MasterInteraction $interactionRef
 * @property MasterInteraction $parentInteractionRef
 * @property StudentWorkplan $parentRef
 * @property StudentWorkplan[] $studentWorkplans
 * @property Task $taskRef
 * @property TblAdmin $modifiedBy
 * @property TblUserMaster $userRef
 * @property StudentWorkplanNotes[] $studentWorkplanNotes
 */
class BaseStudentWorkplan extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentWorkplan the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_workplan';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, workplan_ref_id', 'required'),
			array('workplan_ref_id, interaction_ref_id, start_date, start_month, start_year, end_date, end_month, end_year, parent_interaction_ref_id, modified_by', 'numerical', 'integerOnly'=>true),
			array('parent_ref_id, user_ref_id, task_ref_id', 'length', 'max'=>10),
			array('description', 'length', 'max'=>500),
			array('activity_status', 'length', 'max'=>18),
			array('complete_date, parent_signoff_date, comments, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_workplan_id, parent_ref_id, user_ref_id, workplan_ref_id, interaction_ref_id, task_ref_id, start_date, start_month, start_year, end_date, end_month, end_year, description, activity_status, complete_date, parent_interaction_ref_id, parent_signoff_date, comments, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'workplanRef' => array(self::BELONGS_TO, 'LookupWorkplan', 'workplan_ref_id'),
			'interactionRef' => array(self::BELONGS_TO, 'MasterInteraction', 'interaction_ref_id'),
			'parentInteractionRef' => array(self::BELONGS_TO, 'MasterInteraction', 'parent_interaction_ref_id'),
			'parentRef' => array(self::BELONGS_TO, 'StudentWorkplan', 'parent_ref_id'),
			'studentWorkplans' => array(self::HAS_MANY, 'StudentWorkplan', 'parent_ref_id'),
			'taskRef' => array(self::BELONGS_TO, 'Task', 'task_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'TblAdmin', 'modified_by'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'studentWorkplanNotes' => array(self::HAS_MANY, 'StudentWorkplanNotes', 'student_workplan_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_workplan_id' => 'Student Workplan',
			'parent_ref_id' => 'Parent Ref',
			'user_ref_id' => 'User Ref',
			'workplan_ref_id' => 'Workplan Ref',
			'interaction_ref_id' => 'Interaction Ref',
			'task_ref_id' => 'Task Ref',
			'start_date' => 'Start Date',
			'start_month' => 'Start Month',
			'start_year' => 'Start Year',
			'end_date' => 'End Date',
			'end_month' => 'End Month',
			'end_year' => 'End Year',
			'description' => 'Description',
			'activity_status' => 'Activity Status',
			'complete_date' => 'Complete Date',
			'parent_interaction_ref_id' => 'Parent Interaction Ref',
			'parent_signoff_date' => 'Parent Signoff Date',
			'comments' => 'Comments',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_workplan_id',$this->student_workplan_id,true);
		$criteria->compare('parent_ref_id',$this->parent_ref_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('workplan_ref_id',$this->workplan_ref_id);
		$criteria->compare('interaction_ref_id',$this->interaction_ref_id);
		$criteria->compare('task_ref_id',$this->task_ref_id,true);
		$criteria->compare('start_date',$this->start_date);
		$criteria->compare('start_month',$this->start_month);
		$criteria->compare('start_year',$this->start_year);
		$criteria->compare('end_date',$this->end_date);
		$criteria->compare('end_month',$this->end_month);
		$criteria->compare('end_year',$this->end_year);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('activity_status',$this->activity_status,true);
		$criteria->compare('complete_date',$this->complete_date,true);
		$criteria->compare('parent_interaction_ref_id',$this->parent_interaction_ref_id);
		$criteria->compare('parent_signoff_date',$this->parent_signoff_date,true);
		$criteria->compare('comments',$this->comments,true);
		$criteria->compare('modified_by',$this->modified_by);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}