<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentSummerPlan is autogenerate by UniModel generator
 *
 * This is the model class for table "student_summer_plan".
 *
 * The followings are the available columns in table 'student_summer_plan':
 * @property string $student_summer_plan_id
 * @property string $user_ref_id
 * @property integer $summer_plan_ref_id
 * @property string $stu_entered_plan1
 * @property string $stu_entered_plan2
 * @property string $is_active
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LookupSummerPlan $summerPlanRef
 * @property TblUserMaster $userRef
 */
class BaseStudentSummerPlan extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentSummerPlan the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_summer_plan';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('summer_plan_ref_id', 'numerical', 'integerOnly'=>true),
			array('user_ref_id', 'length', 'max'=>10),
			array('is_active', 'length', 'max'=>1),
			array('stu_entered_plan1, stu_entered_plan2, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_summer_plan_id, user_ref_id, summer_plan_ref_id, stu_entered_plan1, stu_entered_plan2, is_active, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'summerPlanRef' => array(self::BELONGS_TO, 'LookupSummerPlan', 'summer_plan_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_summer_plan_id' => 'Student Summer Plan',
			'user_ref_id' => 'User Ref',
			'summer_plan_ref_id' => 'Summer Plan Ref',
			'stu_entered_plan1' => 'Stu Entered Plan1',
			'stu_entered_plan2' => 'Stu Entered Plan2',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_summer_plan_id',$this->student_summer_plan_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('summer_plan_ref_id',$this->summer_plan_ref_id);
		$criteria->compare('stu_entered_plan1',$this->stu_entered_plan1,true);
		$criteria->compare('stu_entered_plan2',$this->stu_entered_plan2,true);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}