<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentShortlistUniversity is autogenerate by UniModel generator
 *
 * This is the model class for table "student_shortlist_university".
 *
 * The followings are the available columns in table 'student_shortlist_university':
 * @property string $student_shortlist_university_id
 * @property string $user_ref_id
 * @property integer $uni_ref_id
 * @property string $shortlist_status
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 * @property string $get_alert
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property LoginMaster $modifiedBy
 * @property TblUniversityMaster $uniRef
 * @property TblUserMaster $userRef
 */
class BaseStudentShortlistUniversity extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentShortlistUniversity the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_shortlist_university';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, uni_ref_id, added_on, added_by', 'required'),
			array('uni_ref_id', 'numerical', 'integerOnly'=>true),
			array('user_ref_id, shortlist_status, added_by, modified_by', 'length', 'max'=>10),
			array('modified_on', 'safe'),
            array('get_alert', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_shortlist_university_id, user_ref_id, uni_ref_id, shortlist_status, added_on, added_by, modified_on, modified_by, get_alert,is_eoi', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_shortlist_university_id' => 'Student Shortlist University',
			'user_ref_id' => 'User Ref',
			'uni_ref_id' => 'Uni Ref',
			'shortlist_status' => 'Shortlist Status',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
            'get_alert' => 'Get Alert',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_shortlist_university_id',$this->student_shortlist_university_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('shortlist_status',$this->shortlist_status,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);
        $criteria->compare('get_alert',$this->get_alert,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}