<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentProductComment is autogenerate by UniModel generator
 *
 * This is the model class for table "student_product_comment".
 *
 * The followings are the available columns in table 'student_product_comment':
 * @property string $comment_id
 * @property string $student_ref_id
 * @property string $comment
 * @property integer $entered_by
 * @property string $entered_on
 *
 * The followings are the available model relations:
 * @property TblAdmin $enteredBy
 * @property TblUserMaster $studentRef
 */
class BaseStudentProductComment extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentProductComment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_product_comment';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('student_ref_id, comment, entered_by, entered_on', 'required'),
			array('entered_by', 'numerical', 'integerOnly'=>true),
			array('student_ref_id', 'length', 'max'=>10),
			array('comment', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('comment_id, student_ref_id, comment, entered_by, entered_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'enteredBy' => array(self::BELONGS_TO, 'TblAdmin', 'entered_by'),
			'studentRef' => array(self::BELONGS_TO, 'TblUserMaster', 'student_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'comment_id' => 'Comment',
			'student_ref_id' => 'Student Ref',
			'comment' => 'Comment',
			'entered_by' => 'Entered By',
			'entered_on' => 'Entered On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('comment_id',$this->comment_id,true);
		$criteria->compare('student_ref_id',$this->student_ref_id,true);
		$criteria->compare('comment',$this->comment,true);
		$criteria->compare('entered_by',$this->entered_by);
		$criteria->compare('entered_on',$this->entered_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}