<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentPreferredUniversity is autogenerate by UniModel generator
 *
 * This is the model class for table "student_preferred_university".
 *
 * The followings are the available columns in table 'student_preferred_university':
 * @property string $preferred_university_id
 * @property string $user_ref_id
 * @property integer $university_ref_id
 * @property string $university_name
 * @property string $added_on
 * @property integer $is_preferred
 * @property integer $is_applied
 *
 * The followings are the available model relations:
 * @property TblUniversityMaster $universityRef
 * @property TblUserMaster $userRef
 */
class BaseStudentPreferredUniversity extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentPreferredUniversity the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_preferred_university';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id', 'required'),
			array('university_ref_id, is_preferred, is_applied', 'numerical', 'integerOnly'=>true),
			array('user_ref_id', 'length', 'max'=>10),
			array('university_name', 'length', 'max'=>255),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('preferred_university_id, user_ref_id, university_ref_id, university_name, added_on, is_preferred, is_applied', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'universityRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'university_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'preferred_university_id' => 'Preferred University',
			'user_ref_id' => 'User Ref',
			'university_ref_id' => 'University Ref',
			'university_name' => 'University Name',
			'added_on' => 'Added On',
			'is_preferred' => 'Is Preferred',
			'is_applied' => 'Is Applied',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('preferred_university_id',$this->preferred_university_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('university_ref_id',$this->university_ref_id);
		$criteria->compare('university_name',$this->university_name,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('is_preferred',$this->is_preferred);
		$criteria->compare('is_applied',$this->is_applied);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}