<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentPreferredCountryLog is autogenerate by UniModel generator
 *
 * This is the model class for table "student_preferred_country_log".
 *
 * The followings are the available columns in table 'student_preferred_country_log':
 * @property integer $preferred_country_log_id
 * @property integer $user_ref_id
 * @property integer $country_ref_id
 * @property string $added_on
 * @property integer $not_sure
 */
class BaseStudentPreferredCountryLog extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentPreferredCountryLog the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_preferred_country_log';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, country_ref_id, not_sure', 'numerical', 'integerOnly'=>true),
			array('added_on, logged_for', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('preferred_country_log_id, user_ref_id, country_ref_id, added_on, not_sure, logged_for', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'preferred_country_log_id' => 'Preferred Country Log',
			'user_ref_id' => 'User Ref',
			'country_ref_id' => 'Country Ref',
			'added_on' => 'Added On',
			'not_sure' => 'Not Sure',
		    'logged_for'=> 'Log Reason'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('preferred_country_log_id',$this->preferred_country_log_id);
		$criteria->compare('user_ref_id',$this->user_ref_id);
		$criteria->compare('country_ref_id',$this->country_ref_id);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('not_sure',$this->not_sure);
		$criteria->compare('logged_for', $this->logged_for);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}