<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentAssignedAdvisor is autogenerate by UniModel generator
 *
 * This is the model class for table "student_assigned_advisor".
 *
 * The followings are the available columns in table 'student_assigned_advisor':
 * @property string $student_assigned_advisor_id
 * @property string $user_ref_id
 * @property integer $primary_advisor_ref_id
 * @property integer $secondary_advisor_ref_id
 * @property string $type_of_gem
 * @property string $signup_date
 * @property integer $target_month
 * @property integer $target_year
 * @property integer $payment_type_ref_id
 * @property string $payment_date
 * @property integer $currency_ref_Id
 * @property integer $amount_paid
 * @property string $gem_status
 * @property integer $is_star_gem
 * @property integer $is_master_gem
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property LookupCurrency $currencyRef
 * @property LoginMaster $modifiedBy
 * @property LookupPaymentType $paymentTypeRef
 * @property TblAdmin $primaryAdvisorRef
 * @property TblAdmin $secondaryAdvisorRef
 * @property TblUserMaster $userRef
 */
class BaseStudentAssignedAdvisor extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentAssignedAdvisor the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_assigned_advisor';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, added_on, added_by', 'required'),
			array('primary_advisor_ref_id, secondary_advisor_ref_id, target_month, target_year, payment_type_ref_id, currency_ref_Id, amount_paid, is_star_gem, is_master_gem', 'numerical', 'integerOnly'=>true),
			array('user_ref_id, gem_status, added_by, modified_by', 'length', 'max'=>10),
			array('type_of_gem', 'length', 'max'=>22),
			array('signup_date, payment_date, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_assigned_advisor_id, user_ref_id, primary_advisor_ref_id, secondary_advisor_ref_id, type_of_gem, signup_date, target_month, target_year, payment_type_ref_id, payment_date, currency_ref_Id, amount_paid, gem_status, is_star_gem, is_master_gem, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'currencyRef' => array(self::BELONGS_TO, 'LookupCurrency', 'currency_ref_Id'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'paymentTypeRef' => array(self::BELONGS_TO, 'LookupPaymentType', 'payment_type_ref_id'),
			'primaryAdvisorRef' => array(self::BELONGS_TO, 'TblAdmin', 'primary_advisor_ref_id'),
			'secondaryAdvisorRef' => array(self::BELONGS_TO, 'TblAdmin', 'secondary_advisor_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_assigned_advisor_id' => 'Student Assigned Advisor',
			'user_ref_id' => 'User Ref',
			'primary_advisor_ref_id' => 'Primary Advisor Ref',
			'secondary_advisor_ref_id' => 'Secondary Advisor Ref',
			'type_of_gem' => 'Type Of Gem',
			'signup_date' => 'Signup Date',
			'target_month' => 'Target Month',
			'target_year' => 'Target Year',
			'payment_type_ref_id' => 'Payment Type Ref',
			'payment_date' => 'Payment Date',
			'currency_ref_Id' => 'Currency Ref',
			'amount_paid' => 'Amount Paid',
			'gem_status' => 'Gem Status',
			'is_star_gem' => 'Is Star Gem',
			'is_master_gem' => 'Is Master Gem',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_assigned_advisor_id',$this->student_assigned_advisor_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('primary_advisor_ref_id',$this->primary_advisor_ref_id);
		$criteria->compare('secondary_advisor_ref_id',$this->secondary_advisor_ref_id);
		$criteria->compare('type_of_gem',$this->type_of_gem,true);
		$criteria->compare('signup_date',$this->signup_date,true);
		$criteria->compare('target_month',$this->target_month);
		$criteria->compare('target_year',$this->target_year);
		$criteria->compare('payment_type_ref_id',$this->payment_type_ref_id);
		$criteria->compare('payment_date',$this->payment_date,true);
		$criteria->compare('currency_ref_Id',$this->currency_ref_Id);
		$criteria->compare('amount_paid',$this->amount_paid);
		$criteria->compare('gem_status',$this->gem_status,true);
		$criteria->compare('is_star_gem',$this->is_star_gem);
		$criteria->compare('is_master_gem',$this->is_master_gem);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}