<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentAlternateEmail is autogenerate by UniModel generator
 *
 * This is the model class for table "student_alternate_email".
 *
 * The followings are the available columns in table 'student_alternate_email':
 * @property string $student_alternate_email_id
 * @property string $login_ref_id
 * @property integer $contact_type_ref_id
 * @property string $email_id
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 * @property integer $is_active
 * @property integer $is_primary
 *
 * The followings are the available model relations:
 * @property LoginMaster $loginRef
 * @property LoginMaster $addedBy
 * @property LoginMaster $modifiedBy
 * @property LookupContactType $contactTypeRef
 */
class BaseStudentAlternateEmail extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentAlternateEmail the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_alternate_email';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('login_ref_id, email_id, added_on, is_active, is_primary', 'required'),
			array('contact_type_ref_id, is_active, is_primary', 'numerical', 'integerOnly'=>true),
			array('login_ref_id, added_by, modified_by', 'length', 'max'=>10),
			array('email_id', 'length', 'max'=>100),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_alternate_email_id, login_ref_id, contact_type_ref_id, email_id, added_on, added_by, modified_on, modified_by, is_active, is_primary', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'loginRef' => array(self::BELONGS_TO, 'LoginMaster', 'login_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'contactTypeRef' => array(self::BELONGS_TO, 'LookupContactType', 'contact_type_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_alternate_email_id' => 'Student Alternate Email',
			'login_ref_id' => 'Login Ref',
			'contact_type_ref_id' => 'Contact Type Ref',
			'email_id' => 'Email',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
			'is_active' => 'Is Active',
			'is_primary' => 'Is Primary',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_alternate_email_id',$this->student_alternate_email_id,true);
		$criteria->compare('login_ref_id',$this->login_ref_id,true);
		$criteria->compare('contact_type_ref_id',$this->contact_type_ref_id);
		$criteria->compare('email_id',$this->email_id,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('is_primary',$this->is_primary);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}