<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseSignupSteps is autogenerate by UniModel generator
 *
 * This is the model class for table "signup_steps".
 *
 * The followings are the available columns in table 'signup_steps':
 * @property string $signup_steps_id
 * @property string $user_ref_id
 * @property integer $step_no
 * @property string $step_url
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 */
class BaseSignupSteps extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SignupSteps the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'signup_steps';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, step_no', 'required'),
			array('step_no', 'numerical', 'integerOnly'=>true),
			array('user_ref_id', 'length', 'max'=>10),
			array('step_url', 'length', 'max'=>100),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('signup_steps_id, user_ref_id, step_no, step_url, added_on,is_completed', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'signup_steps_id' => 'Signup Steps',
			'user_ref_id' => 'User Ref',
			'step_no' => 'Step No',
			'step_url' => 'Step Url',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('signup_steps_id',$this->signup_steps_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('step_no',$this->step_no);
		$criteria->compare('step_url',$this->step_url,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}