<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseSiAdvisor is autogenerate by UniModel generator
 *
 * This is the model class for table "si_advisor".
 *
 * The followings are the available columns in table 'si_advisor':
 * @property integer $si_advisor_id
 * @property integer $advisor_id
 * @property integer $si_id
 * @property string $start_date
 * @property string $end_date
 * @property integer $revisor
 * @property string $revision_date
 * @property string $is_primary
 *
 * The followings are the available model relations:
 * @property TblAdmin $advisor
 * @property TblSiDi $si
 */
class BaseSiAdvisor extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SiAdvisor the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'si_advisor';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('advisor_id, si_id', 'required'),
			array('advisor_id, si_id, revisor', 'numerical', 'integerOnly'=>true),
			array('is_primary', 'length', 'max'=>1),
			array('start_date, end_date, revision_date', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('si_advisor_id, advisor_id, si_id, start_date, end_date, revisor, revision_date, is_primary', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'advisor' => array(self::BELONGS_TO, 'TblAdmin', 'advisor_id'),
			'si' => array(self::BELONGS_TO, 'TblSiDi', 'si_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'si_advisor_id' => 'Si Advisor',
			'advisor_id' => 'Advisor',
			'si_id' => 'Si',
			'start_date' => 'Start Date',
			'end_date' => 'End Date',
			'revisor' => 'Revisor',
			'revision_date' => 'Revision Date',
			'is_primary' => 'Is Primary',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('si_advisor_id',$this->si_advisor_id);
		$criteria->compare('advisor_id',$this->advisor_id);
		$criteria->compare('si_id',$this->si_id);
		$criteria->compare('start_date',$this->start_date,true);
		$criteria->compare('end_date',$this->end_date,true);
		$criteria->compare('revisor',$this->revisor);
		$criteria->compare('revision_date',$this->revision_date,true);
		$criteria->compare('is_primary',$this->is_primary,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}