<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseSeoUniversity is autogenerate by UniModel generator
 *
 * This is the model class for table "seo_university".
 *
 * The followings are the available columns in table 'seo_university':
 * @property string $seo_university_id
 * @property integer $uni_ref_id
 * @property string $heading
 * @property string $title
 * @property string $meta_keyword
 * @property string $meta_desc
 * @property string $alt_logo
 * @property string $alt_banner
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUniversityMaster $uniRef
 */
class BaseSeoUniversity extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SeoUniversity the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'seo_university';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_ref_id', 'numerical', 'integerOnly'=>true),
			array('heading, title, alt_logo, alt_banner', 'length', 'max'=>255),
			array('meta_keyword, meta_desc, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('seo_university_id, uni_ref_id, heading, title, meta_keyword, meta_desc, alt_logo, alt_banner, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'seo_university_id' => 'Seo University',
			'uni_ref_id' => 'Uni Ref',
			'heading' => 'Heading',
			'title' => 'Title',
			'meta_keyword' => 'Meta Keyword',
			'meta_desc' => 'Meta Desc',
			'alt_logo' => 'Alt Logo',
			'alt_banner' => 'Alt Banner',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('seo_university_id',$this->seo_university_id,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('heading',$this->heading,true);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('meta_keyword',$this->meta_keyword,true);
		$criteria->compare('meta_desc',$this->meta_desc,true);
		$criteria->compare('alt_logo',$this->alt_logo,true);
		$criteria->compare('alt_banner',$this->alt_banner,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}