<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseSeoCity is autogenerate by UniModel generator
 *
 * This is the model class for table "seo_city".
 *
 * The followings are the available columns in table 'seo_city':
 * @property string $seo_city_id
 * @property integer $city_ref_id
 * @property string $seo_city_name
 *
 * The followings are the available model relations:
 * @property TblCityMaster $cityRef
 */
class BaseSeoCity extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SeoCity the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'seo_city';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('city_ref_id', 'numerical', 'integerOnly'=>true),
			array('seo_city_name', 'length', 'max'=>50),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('seo_city_id, city_ref_id, seo_city_name', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'cityRef' => array(self::BELONGS_TO, 'TblCityMaster', 'city_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'seo_city_id' => 'Seo City',
			'city_ref_id' => 'City Ref',
			'seo_city_name' => 'Seo City Name',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('seo_city_id',$this->seo_city_id,true);
		$criteria->compare('city_ref_id',$this->city_ref_id);
		$criteria->compare('seo_city_name',$this->seo_city_name,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}