<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseOrderMaster is autogenerate by UniModel generator
 *
 * This is the model class for table "order_master".
 *
 * The followings are the available columns in table 'order_master':
 * @property string $order_master_id
 * @property integer $invoice_number
 * @property string $login_ref_id
 * @property string $invoice_customer_ref_id
 * @property string $invoice_due_date
 * @property integer $payment_status_ref_id
 * @property string $order_date
 * @property double $order_grand_tax
 * @property double $order_grand_discount
 * @property double $order_grand_total
 * @property string $order_status
 * @property string $added_on
 * @property string $added_by
 * @property string $comments
 *
 * The followings are the available model relations:
 * @property OrderItem[] $orderItems
 * @property InvoiceCustomer $invoiceCustomerRef
 * @property LoginMaster $loginRef
 * @property LookupPaymentStatus $paymentStatusRef
 * @property OrderPayment[] $orderPayments
 * @property SessionBooking[] $sessionBookings
 */
class BaseOrderMaster extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return OrderMaster the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'order_master';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('invoice_number, payment_status_ref_id', 'numerical', 'integerOnly'=>true),
			array('order_grand_tax, order_grand_discount, order_grand_total', 'numerical'),
			array('login_ref_id, invoice_customer_ref_id, added_by', 'length', 'max'=>10),
			array('order_status', 'length', 'max'=>9),
			array('invoice_due_date, order_date, added_on, comments', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('order_master_id, invoice_number, login_ref_id, invoice_customer_ref_id, invoice_due_date, payment_status_ref_id, order_date, order_grand_tax, order_grand_discount, order_grand_total, order_status, added_on, added_by, comments', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'orderItems' => array(self::HAS_MANY, 'OrderItem', 'order_master_ref_id'),
			'invoiceCustomerRef' => array(self::BELONGS_TO, 'InvoiceCustomer', 'invoice_customer_ref_id'),
			'loginRef' => array(self::BELONGS_TO, 'LoginMaster', 'login_ref_id'),
			'paymentStatusRef' => array(self::BELONGS_TO, 'LookupPaymentStatus', 'payment_status_ref_id'),
			'orderPayments' => array(self::HAS_MANY, 'OrderPayment', 'order_master_ref_id'),
			'sessionBookings' => array(self::HAS_MANY, 'SessionBooking', 'order_master_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'order_master_id' => 'Order Master',
			'invoice_number' => 'Invoice Number',
			'login_ref_id' => 'Login Ref',
			'invoice_customer_ref_id' => 'Invoice Customer Ref',
			'invoice_due_date' => 'Invoice Due Date',
			'payment_status_ref_id' => 'Payment Status Ref',
			'order_date' => 'Order Date',
			'order_grand_tax' => 'Order Grand Tax',
			'order_grand_discount' => 'Order Grand Discount',
			'order_grand_total' => 'Order Grand Total',
			'order_status' => 'Order Status',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'comments' => 'Comments',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('order_master_id',$this->order_master_id,true);
		$criteria->compare('invoice_number',$this->invoice_number);
		$criteria->compare('login_ref_id',$this->login_ref_id,true);
		$criteria->compare('invoice_customer_ref_id',$this->invoice_customer_ref_id,true);
		$criteria->compare('invoice_due_date',$this->invoice_due_date,true);
		$criteria->compare('payment_status_ref_id',$this->payment_status_ref_id);
		$criteria->compare('order_date',$this->order_date,true);
		$criteria->compare('order_grand_tax',$this->order_grand_tax);
		$criteria->compare('order_grand_discount',$this->order_grand_discount);
		$criteria->compare('order_grand_total',$this->order_grand_total);
		$criteria->compare('order_status',$this->order_status,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('comments',$this->comments,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}