<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseMockTestResult is autogenerate by UniModel generator
 *
 * This is the model class for table "mock_test_result".
 *
 * The followings are the available columns in table 'mock_test_result':
 * @property string $mock_test_result_id
 * @property string $user_ref_id
 * @property string $mock_test_ref_id
 * @property integer $no_attempted
 * @property integer $no_correct_answers
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 * @property TblMockTest $mockTestRef
 * @property MockTestUserAnswers[] $mockTestUserAnswers
 */
class BaseMockTestResult extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return MockTestResult the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'mock_test_result';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('no_attempted, no_correct_answers', 'numerical', 'integerOnly'=>true),
			array('user_ref_id, mock_test_ref_id', 'length', 'max'=>10),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('mock_test_result_id, user_ref_id, mock_test_ref_id, no_attempted, no_correct_answers, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'mockTestRef' => array(self::BELONGS_TO, 'TblMockTest', 'mock_test_ref_id'),
			'mockTestUserAnswers' => array(self::HAS_MANY, 'MockTestUserAnswers', 'mock_test_result_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'mock_test_result_id' => 'Mock Test Result',
			'user_ref_id' => 'User Ref',
			'mock_test_ref_id' => 'Mock Test Ref',
			'no_attempted' => 'No Attempted',
			'no_correct_answers' => 'No Correct Answers',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('mock_test_result_id',$this->mock_test_result_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('mock_test_ref_id',$this->mock_test_ref_id,true);
		$criteria->compare('no_attempted',$this->no_attempted);
		$criteria->compare('no_correct_answers',$this->no_correct_answers);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}