<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseMockTestQuestions is autogenerate by UniModel generator
 *
 * This is the model class for table "mock_test_questions".
 *
 * The followings are the available columns in table 'mock_test_questions':
 * @property string $mock_test_questions_id
 * @property string $mock_test_section_ref_id
 * @property string $title
 * @property string $img_path
 * @property string $explanation
 * @property string $explanation_path
 * @property string $is_active
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 *
 * The followings are the available model relations:
 * @property MockTestQueOptions[] $mockTestQueOptions
 * @property MockTestSections $mockTestSectionRef
 * @property LoginMaster $addedBy
 * @property LoginMaster $modifiedBy
 * @property MockTestUserAnswers[] $mockTestUserAnswers
 */
class BaseMockTestQuestions extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return MockTestQuestions the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'mock_test_questions';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('mock_test_section_ref_id, added_by, modified_by', 'length', 'max'=>10),
			array('is_active', 'length', 'max'=>1),
			array('title, added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('mock_test_questions_id, mock_test_section_ref_id, title, explanation, is_active, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'mockTestQueOptions' => array(self::HAS_MANY, 'MockTestQueOptions', 'mock_test_questions_ref_id'),
			'mockTestSectionRef' => array(self::BELONGS_TO, 'MockTestSections', 'mock_test_section_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'mockTestUserAnswers' => array(self::HAS_MANY, 'MockTestUserAnswers', 'question_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'mock_test_questions_id' => 'Mock Test Questions',
			'mock_test_section_ref_id' => 'Mock Test Section Ref',
			'title' => 'Title',
			'explanation' => 'Explanation',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('mock_test_questions_id',$this->mock_test_questions_id,true);
		$criteria->compare('mock_test_section_ref_id',$this->mock_test_section_ref_id,true);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('img_path',$this->img_path,true);
		$criteria->compare('explanation',$this->explanation,true);
		$criteria->compare('explanation_path',$this->explanation_path,true);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}