<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseMilestoneCounsellingTimetrack is autogenerate by UniModel generator
 *
 * This is the model class for table "milestone_counselling_timetrack".
 *
 * The followings are the available columns in table 'milestone_counselling_timetrack':
 * @property string $milestone_counselling_timetrack_id
 * @property string $session_id
 * @property string $student_ref_id
 * @property integer $milestone_ref_id
 * @property integer $counsellor_ref_id
 * @property string $start_time
 * @property string $end_time
 *
 * The followings are the available model relations:
 * @property TblAdmin $counsellorRef
 * @property LookupMilestone $milestoneRef
 * @property TblUserMaster $studentRef
 */
class BaseMilestoneCounsellingTimetrack extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return MilestoneCounsellingTimetrack the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'milestone_counselling_timetrack';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('session_id, student_ref_id, milestone_ref_id, counsellor_ref_id', 'required'),
			array('milestone_ref_id, counsellor_ref_id', 'numerical', 'integerOnly'=>true),
			array('session_id', 'length', 'max'=>50),
			array('student_ref_id', 'length', 'max'=>10),
			array('start_time, end_time', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('milestone_counselling_timetrack_id, session_id, student_ref_id, milestone_ref_id, counsellor_ref_id, start_time, end_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'counsellorRef' => array(self::BELONGS_TO, 'TblAdmin', 'counsellor_ref_id'),
			'milestoneRef' => array(self::BELONGS_TO, 'LookupMilestone', 'milestone_ref_id'),
			'studentRef' => array(self::BELONGS_TO, 'TblUserMaster', 'student_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'milestone_counselling_timetrack_id' => 'Milestone Counselling Timetrack',
			'session_id' => 'Session',
			'student_ref_id' => 'Student Ref',
			'milestone_ref_id' => 'Milestone Ref',
			'counsellor_ref_id' => 'Counsellor Ref',
			'start_time' => 'Start Time',
			'end_time' => 'End Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('milestone_counselling_timetrack_id',$this->milestone_counselling_timetrack_id,true);
		$criteria->compare('session_id',$this->session_id,true);
		$criteria->compare('student_ref_id',$this->student_ref_id,true);
		$criteria->compare('milestone_ref_id',$this->milestone_ref_id);
		$criteria->compare('counsellor_ref_id',$this->counsellor_ref_id);
		$criteria->compare('start_time',$this->start_time,true);
		$criteria->compare('end_time',$this->end_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}