<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseMasterEthnicity is autogenerate by UniModel generator
 *
 * This is the model class for table "master_ethnicity".
 *
 * The followings are the available columns in table 'master_ethnicity':
 * @property integer $ethnicity_id
 * @property string $ethnicity_name
 * @property string $country_id
 * @property string $is_active
 * @property integer $display_order
 *
 * The followings are the available model relations:
 * @property TblUserMaster[] $tblUserMasters
 * @property UniversityEthnicity[] $universityEthnicities
 */
class BaseMasterEthnicity extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return MasterEthnicity the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'master_ethnicity';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('display_order', 'numerical', 'integerOnly'=>true),
			array('ethnicity_name', 'length', 'max'=>50),
			array('country_id', 'length', 'max'=>500),
			array('is_active', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('ethnicity_id, ethnicity_name, country_id, is_active, display_order', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'tblUserMasters' => array(self::HAS_MANY, 'TblUserMaster', 'ethnicity_ref_id'),//'tblUserMasters' => array(self::HAS_MANY, 'TblUserMaster', 'ethnicity') ////TODO: #994 changed 'ethnicity to ethnicity_ref_id' Fields
			'universityEthnicities' => array(self::HAS_MANY, 'UniversityEthnicity', 'ethnicity_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'ethnicity_id' => 'Ethnicity',
			'ethnicity_name' => 'Ethnicity Name',
			'country_id' => 'Country',
			'is_active' => 'Is Active',
			'display_order' => 'Display Order',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('ethnicity_id',$this->ethnicity_id);
		$criteria->compare('ethnicity_name',$this->ethnicity_name,true);
		$criteria->compare('country_id',$this->country_id,true);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('display_order',$this->display_order);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}