<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupUserInterest is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_user_interest".
 *
 * The followings are the available columns in table 'lookup_user_interest':
 * @property integer $user_interest_id
 * @property string $interest
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LookupUserInterestLevel[] $lookupUserInterestLevels
 * @property LookupUserInterestType[] $lookupUserInterestTypes
 * @property TblUserInterest[] $tblUserInterests
 */
class BaseLookupUserInterest extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupUserInterest the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_user_interest';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('interest', 'required'),
			array('interest', 'length', 'max'=>25),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('user_interest_id, interest, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'lookupUserInterestLevels' => array(self::HAS_MANY, 'LookupUserInterestLevel', 'user_interest_ref_id'),
			'lookupUserInterestTypes' => array(self::HAS_MANY, 'LookupUserInterestType', 'user_interest_ref_id'),
			'tblUserInterests' => array(self::HAS_MANY, 'TblUserInterest', 'user_interest_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'user_interest_id' => 'User Interest',
			'interest' => 'Interest',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('user_interest_id',$this->user_interest_id);
		$criteria->compare('interest',$this->interest,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}