<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupUniversityAffiliation is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_university_affiliation".
 *
 * The followings are the available columns in table 'lookup_university_affiliation':
 * @property integer $university_affiliation_id
 * @property string $university_code
 * @property string $univeristy_name
 * @property string $state
 * @property string $location
 * @property integer $established
 * @property string $specialization
 * @property string $university_type
 * @property integer $is_active
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUniversityMaster[] $tblUniversityMasters
 */
class BaseLookupUniversityAffiliation extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupUniversityAffiliation the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_university_affiliation';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('univeristy_name, added_on', 'required'),
			array('established, is_active', 'numerical', 'integerOnly'=>true),
			array('university_code', 'length', 'max'=>10),
			array('univeristy_name, specialization', 'length', 'max'=>100),
			array('state, location', 'length', 'max'=>50),
			array('university_type', 'length', 'max'=>7),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('university_affiliation_id, university_code, univeristy_name, state, location, established, specialization, university_type, is_active, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'tblUniversityMasters' => array(self::HAS_MANY, 'TblUniversityMaster', 'university_affiliation_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'university_affiliation_id' => 'University Affiliation',
			'university_code' => 'University Code',
			'univeristy_name' => 'Univeristy Name',
			'state' => 'State',
			'location' => 'Location',
			'established' => 'Established',
			'specialization' => 'Specialization',
			'university_type' => 'University Type',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('university_affiliation_id',$this->university_affiliation_id);
		$criteria->compare('university_code',$this->university_code,true);
		$criteria->compare('univeristy_name',$this->univeristy_name,true);
		$criteria->compare('state',$this->state,true);
		$criteria->compare('location',$this->location,true);
		$criteria->compare('established',$this->established);
		$criteria->compare('specialization',$this->specialization,true);
		$criteria->compare('university_type',$this->university_type,true);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}