<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupSubjectMaster is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_subject_master".
 *
 * The followings are the available columns in table 'lookup_subject_master':
 * @property string $subject_master_id
 * @property string $subject_name
 * @property string $added_on
 * @property string $user_entered
 *
 * The followings are the available model relations:
 * @property DepartmentSubject[] $departmentSubjects
 * @property LookupStudentSubject[] $lookupStudentSubjects
 */
class BaseLookupSubjectMaster extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupSubjectMaster the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_subject_master';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('subject_name', 'required'),
			array('subject_name', 'length', 'max'=>100),
			array('user_entered', 'length', 'max'=>1),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('subject_master_id, subject_name, added_on, user_entered', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'departmentSubjects' => array(self::HAS_MANY, 'DepartmentSubject', 'subject_ref_id'),
			'lookupStudentSubjects' => array(self::HAS_MANY, 'LookupStudentSubject', 'subject_master_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'subject_master_id' => 'Subject Master',
			'subject_name' => 'Subject Name',
			'added_on' => 'Added On',
			'user_entered' => 'User Entered',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('subject_master_id',$this->subject_master_id,true);
		$criteria->compare('subject_name',$this->subject_name,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('user_entered',$this->user_entered,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}