<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupScholarshipType is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_scholarship_type".
 *
 * The followings are the available columns in table 'lookup_scholarship_type':
 * @property integer $scholarship_type_id
 * @property string $type_name
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property Scholarship[] $scholarships
 */
class BaseLookupScholarshipType extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupScholarshipType the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_scholarship_type';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('type_name, added_on', 'required'),
			array('type_name', 'length', 'max'=>100),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('scholarship_type_id, type_name, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'scholarships' => array(self::HAS_MANY, 'Scholarship', 'scholarship_type_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'scholarship_type_id' => 'Scholarship Type',
			'type_name' => 'Type Name',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('scholarship_type_id',$this->scholarship_type_id);
		$criteria->compare('type_name',$this->type_name,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}