<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupRankSource is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_rank_source".
 *
 * The followings are the available columns in table 'lookup_rank_source':
 * @property integer $rank_source_id
 * @property string $source_name
 * @property string $source_type
 * @property integer $country_ref_id
 *
 * The followings are the available model relations:
 * @property TblCountryMaster $countryRef
 * @property UniversityDeptRanking[] $universityDeptRankings
 * @property UniversityRanking[] $universityRankings
 */
class BaseLookupRankSource extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupRankSource the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_rank_source';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('source_name', 'required'),
			array('country_ref_id', 'numerical', 'integerOnly'=>true),
			array('source_name', 'length', 'max'=>75),
			array('source_type', 'length', 'max'=>7),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('rank_source_id, source_name, source_type, country_ref_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'countryRef' => array(self::BELONGS_TO, 'TblCountryMaster', 'country_ref_id'),
			'universityDeptRankings' => array(self::HAS_MANY, 'UniversityDeptRanking', 'rank_source_ref_id'),
			'universityRankings' => array(self::HAS_MANY, 'UniversityRanking', 'rank_source_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'rank_source_id' => 'Rank Source',
			'source_name' => 'Source Name',
			'source_type' => 'Source Type',
			'country_ref_id' => 'Country Ref',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('rank_source_id',$this->rank_source_id);
		$criteria->compare('source_name',$this->source_name,true);
		$criteria->compare('source_type',$this->source_type,true);
		$criteria->compare('country_ref_id',$this->country_ref_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}