<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupProspectStatus is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_prospect_status".
 *
 * The followings are the available columns in table 'lookup_prospect_status':
 * @property integer $lookup_prospect_status_id
 * @property integer $main_status_id
 * @property string $status_name
 * @property string $is_followup
 * @property string $added_on
 * @property string $is_active
 *
 * The followings are the available model relations:
 * @property Prospect[] $prospects
 * @property Prospect[] $prospects1
 * @property ProspectInteraction[] $prospectInteractions
 * @property ProspectInteraction[] $prospectInteractions1
 */
class BaseLookupProspectStatus extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupProspectStatus the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_prospect_status';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('added_on', 'required'),
			array('main_status_id', 'numerical', 'integerOnly'=>true),
			array('status_name', 'length', 'max'=>255),
			array('is_followup, is_active', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('lookup_prospect_status_id, main_status_id, status_name, is_followup, added_on, is_active', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'prospects' => array(self::HAS_MANY, 'Prospect', 'prospect_main_status_ref_id'),
			'prospects1' => array(self::HAS_MANY, 'Prospect', 'prospect_sub_status_ref_id'),
			'prospectInteractions' => array(self::HAS_MANY, 'ProspectInteraction', 'prospect_main_status_ref_id'),
			'prospectInteractions1' => array(self::HAS_MANY, 'ProspectInteraction', 'prospect_sub_status_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'lookup_prospect_status_id' => 'Lookup Prospect Status',
			'main_status_id' => 'Main Status',
			'status_name' => 'Status Name',
			'is_followup' => 'Is Followup',
			'added_on' => 'Added On',
			'is_active' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('lookup_prospect_status_id',$this->lookup_prospect_status_id);
		$criteria->compare('main_status_id',$this->main_status_id);
		$criteria->compare('status_name',$this->status_name,true);
		$criteria->compare('is_followup',$this->is_followup,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('is_active',$this->is_active,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}