<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupMocktestCriteria is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_mocktest_criteria".
 *
 * The followings are the available columns in table 'lookup_mocktest_criteria':
 * @property string $mocktest_criteria_id
 * @property string $mock_test_ref_id
 * @property integer $min_percentage
 * @property integer $max_percentage
 * @property string $text_image_path
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 *
 * The followings are the available model relations:
 * @property TblMockTest $mockTestRef
 * @property LoginMaster $addedBy
 * @property LoginMaster $modifiedBy
 */
class BaseLookupMocktestCriteria extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupMocktestCriteria the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_mocktest_criteria';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('min_percentage, max_percentage', 'numerical', 'integerOnly'=>true),
			array('mock_test_ref_id, added_by, modified_by', 'length', 'max'=>10),
			array('text_image_path', 'length', 'max'=>150),
			array('added_on, modified_on, criteria_label', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('mocktest_criteria_id, mock_test_ref_id, min_percentage, max_percentage, criteria_label, text_image_path, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'mockTestRef' => array(self::BELONGS_TO, 'TblMockTest', 'mock_test_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'mocktest_criteria_id' => 'Mocktest Criteria',
			'mock_test_ref_id' => 'Mock Test Ref',
			'min_percentage' => 'Min Percentage',
			'max_percentage' => 'Max Percentage',
			'text_image_path' => 'Text Image Path',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('mocktest_criteria_id',$this->mocktest_criteria_id,true);
		$criteria->compare('mock_test_ref_id',$this->mock_test_ref_id,true);
		$criteria->compare('min_percentage',$this->min_percentage);
		$criteria->compare('max_percentage',$this->max_percentage);
		$criteria->compare('text_image_path',$this->text_image_path,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}