<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupIntake is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_intake".
 *
 * The followings are the available columns in table 'lookup_intake':
 * @property integer $intake_id
 * @property string $intake
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property UniversityDateIntake[] $universityDateIntakes
 */
class BaseLookupIntake extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupIntake the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_intake';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('intake, added_on', 'required'),
			array('intake', 'length', 'max'=>20),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('intake_id, intake, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'universityDateIntakes' => array(self::HAS_MANY, 'UniversityDateIntake', 'intake_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'intake_id' => 'Intake',
			'intake' => 'Intake',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('intake_id',$this->intake_id);
		$criteria->compare('intake',$this->intake,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}