<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupFeedbackType is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_feedback_type".
 *
 * The followings are the available columns in table 'lookup_feedback_type':
 * @property integer $feedback_type_id
 * @property string $feedback_type
 * @property integer $has_comment
 *
 * The followings are the available model relations:
 * @property LookupFeedbackQuestion[] $lookupFeedbackQuestions
 * @property WorkshopSiGroupFeedback[] $workshopSiGroupFeedbacks
 */
class BaseLookupFeedbackType extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupFeedbackType the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_feedback_type';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('feedback_type', 'required'),
			array('has_comment', 'numerical', 'integerOnly'=>true),
			array('feedback_type', 'length', 'max'=>45),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('feedback_type_id, feedback_type, has_comment', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'lookupFeedbackQuestions' => array(self::HAS_MANY, 'LookupFeedbackQuestion', 'feedback_type_ref_id'),
			'workshopSiGroupFeedbacks' => array(self::HAS_MANY, 'WorkshopSiGroupFeedback', 'feedback_type_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'feedback_type_id' => 'Feedback Type',
			'feedback_type' => 'Feedback Type',
			'has_comment' => 'Has Comment',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('feedback_type_id',$this->feedback_type_id);
		$criteria->compare('feedback_type',$this->feedback_type,true);
		$criteria->compare('has_comment',$this->has_comment);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}