<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupFeedbackQuestion is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_feedback_question".
 *
 * The followings are the available columns in table 'lookup_feedback_question':
 * @property integer $feedback_question_id
 * @property integer $feedback_type_ref_id
 * @property string $question
 * @property integer $is_multiple_answer
 * @property integer $question_order
 * @property integer $is_active
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LookupFeedbackAnswer[] $lookupFeedbackAnswers
 * @property LookupFeedbackType $feedbackTypeRef
 * @property WorkshopSiGroupFeedbackAnswer[] $workshopSiGroupFeedbackAnswers
 */
class BaseLookupFeedbackQuestion extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupFeedbackQuestion the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_feedback_question';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('feedback_type_ref_id, question, question_order', 'required'),
			array('feedback_type_ref_id, is_multiple_answer, question_order, is_active', 'numerical', 'integerOnly'=>true),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('feedback_question_id, feedback_type_ref_id, question, is_multiple_answer, question_order, is_active, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'lookupFeedbackAnswers' => array(self::HAS_MANY, 'LookupFeedbackAnswer', 'feedback_question_ref_id'),
			'feedbackTypeRef' => array(self::BELONGS_TO, 'LookupFeedbackType', 'feedback_type_ref_id'),
			'workshopSiGroupFeedbackAnswers' => array(self::HAS_MANY, 'WorkshopSiGroupFeedbackAnswer', 'feedback_question_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'feedback_question_id' => 'Feedback Question',
			'feedback_type_ref_id' => 'Feedback Type Ref',
			'question' => 'Question',
			'is_multiple_answer' => 'Is Multiple Answer',
			'question_order' => 'Question Order',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('feedback_question_id',$this->feedback_question_id);
		$criteria->compare('feedback_type_ref_id',$this->feedback_type_ref_id);
		$criteria->compare('question',$this->question,true);
		$criteria->compare('is_multiple_answer',$this->is_multiple_answer);
		$criteria->compare('question_order',$this->question_order);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}