<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupContactType is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_contact_type".
 *
 * The followings are the available columns in table 'lookup_contact_type':
 * @property integer $contact_type_id
 * @property string $contact_type
 * @property integer $is_active
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property StudentAlternateEmail[] $studentAlternateEmails
 * @property StudentContactNumber[] $studentContactNumbers
 */
class BaseLookupContactType extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupContactType the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_contact_type';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('contact_type, added_on', 'required'),
			array('is_active', 'numerical', 'integerOnly'=>true),
			array('contact_type', 'length', 'max'=>25),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('contact_type_id, contact_type, is_active, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'studentAlternateEmails' => array(self::HAS_MANY, 'StudentAlternateEmail', 'contact_type_ref_id'),
			'studentContactNumbers' => array(self::HAS_MANY, 'StudentContactNumber', 'contact_type_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'contact_type_id' => 'Contact Type',
			'contact_type' => 'Contact Type',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('contact_type_id',$this->contact_type_id);
		$criteria->compare('contact_type',$this->contact_type,true);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}