<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupCentreStudentStatus is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_centre_student_status".
 *
 * The followings are the available columns in table 'lookup_centre_student_status':
 * @property string $lookup_centre_student_status_id
 * @property string $status_label
 * @property integer $status
 * @property integer $order
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property VendorCentreStudentStatus[] $vendorCentreStudentStatuses
 */
class BaseLookupCentreStudentStatus extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupCentreStudentStatus the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_centre_student_status';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('status_label', 'required'),
			array('status, order', 'numerical', 'integerOnly'=>true),
			array('status_label', 'length', 'max'=>100),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('lookup_centre_student_status_id, status_label, status, order, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'vendorCentreStudentStatuses' => array(self::HAS_MANY, 'VendorCentreStudentStatus', 'student_status_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'lookup_centre_student_status_id' => 'Lookup Centre Student Status',
			'status_label' => 'Status Label',
			'status' => 'Status',
			'order' => 'Order',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('lookup_centre_student_status_id',$this->lookup_centre_student_status_id,true);
		$criteria->compare('status_label',$this->status_label,true);
		$criteria->compare('status',$this->status);
		$criteria->compare('order',$this->order);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}