<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupCareer is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_career".
 *
 * The followings are the available columns in table 'lookup_career':
 * @property string $career_id
 * @property string $url_primary_key
 * @property string $seo_keyword
 * @property integer $main_dept_ref_id
 * @property integer $sub_dept_ref_id
 * @property string $career_name
 * @property string $career_page
 * @property string $career_intro
 * @property string $banner_name
 * @property string $page_thumbnail
 * @property string $big_thumbnail
 * @property integer $preference_order
 * @property integer $is_career_page
 * @property integer $is_popular_career
 * @property integer $is_active
 * @property string $added_on
 * @property string $parent_choice
 *
 * The followings are the available model relations:
 * @property CareerCountry[] $careerCountries
 * @property CareerImages[] $careerImages
 * @property CareerPage[] $careerPages
 * @property CareerTags[] $careerTags
 * @property CareerTags[] $careerTags1
 * @property CareerVideo[] $careerVideos
 * @property LookupDepartment $mainDeptRef
 * @property LookupDepartment $subDeptRef
 * @property LookupCareerInterestMapping[] $lookupCareerInterestMappings
 * @property StudentPreferredCareer[] $studentPreferredCareers
 */
class BaseLookupCareer extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupCareer the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_career';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('url_primary_key, career_name, added_on', 'required'),
			array('main_dept_ref_id, sub_dept_ref_id, preference_order, is_career_page, is_popular_career, is_active', 'numerical', 'integerOnly'=>true),
			array('url_primary_key', 'length', 'max'=>32),
			array('seo_keyword', 'length', 'max'=>128),
			array('career_name, banner_name, page_thumbnail, big_thumbnail', 'length', 'max'=>100),
			array('career_page', 'length', 'max'=>255),
			array('parent_choice', 'length', 'max'=>1),
			array('career_intro', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('career_id, url_primary_key, seo_keyword, main_dept_ref_id, sub_dept_ref_id, career_name, career_page, career_intro, banner_name, page_thumbnail, big_thumbnail, preference_order, is_career_page, is_popular_career, is_active, added_on, parent_choice', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'careerCountries' => array(self::HAS_MANY, 'CareerCountry', 'career_ref_id'),
			'careerImages' => array(self::HAS_MANY, 'CareerImages', 'career_ref_id'),
			'careerPages' => array(self::HAS_MANY, 'CareerPage', 'career_ref_id'),
			'careerTags' => array(self::HAS_MANY, 'CareerTags', 'career_id'),
			'careerTags1' => array(self::HAS_MANY, 'CareerTags', 'career_ref_id'),
			'careerVideos' => array(self::HAS_MANY, 'CareerVideo', 'career_ref_id'),
			'mainDeptRef' => array(self::BELONGS_TO, 'LookupDepartment', 'main_dept_ref_id'),
			'subDeptRef' => array(self::BELONGS_TO, 'LookupDepartment', 'sub_dept_ref_id'),
			'lookupCareerInterestMappings' => array(self::HAS_MANY, 'LookupCareerInterestMapping', 'career_ref_id'),
			'studentPreferredCareers' => array(self::HAS_MANY, 'StudentPreferredCareer', 'career_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'career_id' => 'Career',
			'url_primary_key' => 'Url Primary Key',
			'seo_keyword' => 'Seo Keyword',
			'main_dept_ref_id' => 'Main Dept Ref',
			'sub_dept_ref_id' => 'Sub Dept Ref',
			'career_name' => 'Career Name',
			'career_page' => 'Career Page',
			'career_intro' => 'Career Intro',
			'banner_name' => 'Banner Name',
			'page_thumbnail' => 'Page Thumbnail',
			'big_thumbnail' => 'Big Thumbnail',
			'preference_order' => 'Preference Order',
			'is_career_page' => 'Is Career Page',
			'is_popular_career' => 'Is Popular Career',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
			'parent_choice' => 'Parent Choice',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('career_id',$this->career_id,true);
		$criteria->compare('url_primary_key',$this->url_primary_key,true);
		$criteria->compare('seo_keyword',$this->seo_keyword,true);
		$criteria->compare('main_dept_ref_id',$this->main_dept_ref_id);
		$criteria->compare('sub_dept_ref_id',$this->sub_dept_ref_id);
		$criteria->compare('career_name',$this->career_name,true);
		$criteria->compare('career_page',$this->career_page,true);
		$criteria->compare('career_intro',$this->career_intro,true);
		$criteria->compare('banner_name',$this->banner_name,true);
		$criteria->compare('page_thumbnail',$this->page_thumbnail,true);
		$criteria->compare('big_thumbnail',$this->big_thumbnail,true);
		$criteria->compare('preference_order',$this->preference_order);
		$criteria->compare('is_career_page',$this->is_career_page);
		$criteria->compare('is_popular_career',$this->is_popular_career);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('parent_choice',$this->parent_choice,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}