<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseFbUsers is autogenerate by UniModel generator
 *
 * This is the model class for table "fb_users".
 *
 * The followings are the available columns in table 'fb_users':
 * @property string $id
 * @property string $login_ref_id
 * @property string $fb_id
 * @property string $fb_access_token
 *
 * The followings are the available model relations:
 * @property LoginMaster $loginRef
 */
class BaseFbUsers extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return FbUsers the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'fb_users';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('login_ref_id, fb_id', 'required'),
			array('login_ref_id', 'length', 'max'=>10),
			array('fb_id', 'length', 'max'=>100),
			array('fb_access_token', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, login_ref_id, fb_id, fb_access_token', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'loginRef' => array(self::BELONGS_TO, 'LoginMaster', 'login_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'login_ref_id' => 'Login Ref',
			'fb_id' => 'Fb',
			'fb_access_token' => 'Fb Access Token',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('login_ref_id',$this->login_ref_id,true);
		$criteria->compare('fb_id',$this->fb_id,true);
		$criteria->compare('fb_access_token',$this->fb_access_token,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}