<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEventSi is autogenerate by UniModel generator
 *
 * This is the model class for table "event_si".
 *
 * The followings are the available columns in table 'event_si':
 * @property string $event_si_id
 * @property integer $si_ref_id
 * @property integer $event_ref_id
 * @property string $workshop_si_ref_Id
 * @property string $name
 * @property integer $alert_duration
 * @property string $alert_date
 * @property string $key
 * @property string $type
 * @property integer $graduation_year
 * @property string $where_condition
 * @property integer $is_active
 * @property integer $display_order
 * @property string $added_on
 * @property integer $added_by
 *
 * The followings are the available model relations:
 * @property LookupEvent $eventRef
 * @property TblSiDi $siRef
 * @property WorkshopSi $workshopSiRef
 * @property EventStudent[] $eventStudents
 */
class BaseEventSi extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EventSi the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'event_si';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('event_ref_id', 'required'),
			array('si_ref_id, event_ref_id, alert_duration, graduation_year, is_active, display_order, added_by', 'numerical', 'integerOnly'=>true),
			array('workshop_si_ref_Id', 'length', 'max'=>10),
			array('name', 'length', 'max'=>100),
			array('key', 'length', 'max'=>45),
			array('type', 'length', 'max'=>4),
			array('alert_date, where_condition, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('event_si_id, si_ref_id, event_ref_id, workshop_si_ref_Id, name, alert_duration, alert_date, key, type, graduation_year, where_condition, is_active, display_order, added_on, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'eventRef' => array(self::BELONGS_TO, 'LookupEvent', 'event_ref_id'),
			'siRef' => array(self::BELONGS_TO, 'TblSiDi', 'si_ref_id'),
			'workshopSiRef' => array(self::BELONGS_TO, 'WorkshopSi', 'workshop_si_ref_Id'),
			'eventStudents' => array(self::HAS_MANY, 'EventStudent', 'event_si_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'event_si_id' => 'Event Si',
			'si_ref_id' => 'Si Ref',
			'event_ref_id' => 'Event Ref',
			'workshop_si_ref_Id' => 'Workshop Si Ref',
			'name' => 'Name',
			'alert_duration' => 'Alert Duration',
			'alert_date' => 'Alert Date',
			'key' => 'Key',
			'type' => 'Type',
			'graduation_year' => 'Graduation Year',
			'where_condition' => 'Where Condition',
			'is_active' => 'Is Active',
			'display_order' => 'Display Order',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('event_si_id',$this->event_si_id,true);
		$criteria->compare('si_ref_id',$this->si_ref_id);
		$criteria->compare('event_ref_id',$this->event_ref_id);
		$criteria->compare('workshop_si_ref_Id',$this->workshop_si_ref_Id,true);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('alert_duration',$this->alert_duration);
		$criteria->compare('alert_date',$this->alert_date,true);
		$criteria->compare('key',$this->key,true);
		$criteria->compare('type',$this->type,true);
		$criteria->compare('graduation_year',$this->graduation_year);
		$criteria->compare('where_condition',$this->where_condition,true);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('display_order',$this->display_order);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}