<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEventRegistrants is autogenerate by UniModel generator
 *
 * This is the model class for table "tbl_event_registrants".
 *
 * The followings are the available columns in table 'tbl_event_registrants':
 * @property string $tbl_event_registrants_id
 * @property integer $event_ref_id
 * @property string $user_ref_id
 * @property string $first_name
 * @property string $last_name
 * @property string $email
 * @property string $STATUS
 * @property string $registration_date
 * @property string $join_url
 * @property string $time_zone
 *
 * The followings are the available model relations:
 * @property TblEvent $eventRef
 * @property TblUserMaster $userRef
 */
class BaseEventRegistrants extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EventRegistrants the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_event_registrants';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('event_ref_id', 'numerical', 'integerOnly'=>true),
			array('user_ref_id', 'length', 'max'=>10),
			array('first_name, last_name, email', 'length', 'max'=>100),
			array('STATUS, time_zone', 'length', 'max'=>50),
			array('join_url', 'length', 'max'=>150),
			array('registration_date', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('tbl_event_registrants_id, event_ref_id, user_ref_id, first_name, last_name, email, STATUS, registration_date, join_url, time_zone', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'eventRef' => array(self::BELONGS_TO, 'TblEvent', 'event_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'tbl_event_registrants_id' => 'Tbl Event Registrants',
			'event_ref_id' => 'Event Ref',
			'user_ref_id' => 'User Ref',
			'first_name' => 'First Name',
			'last_name' => 'Last Name',
			'email' => 'Email',
			'STATUS' => 'Status',
			'registration_date' => 'Registration Date',
			'join_url' => 'Join Url',
			'time_zone' => 'Time Zone',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('tbl_event_registrants_id',$this->tbl_event_registrants_id,true);
		$criteria->compare('event_ref_id',$this->event_ref_id);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('first_name',$this->first_name,true);
		$criteria->compare('last_name',$this->last_name,true);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('STATUS',$this->STATUS,true);
		$criteria->compare('registration_date',$this->registration_date,true);
		$criteria->compare('join_url',$this->join_url,true);
		$criteria->compare('time_zone',$this->time_zone,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}