<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEventInvitation is autogenerate by UniModel generator
 *
 * This is the model class for table "event_invitation".
 *
 * The followings are the available columns in table 'event_invitation':
 * @property integer $event_invitation_id
 * @property integer $event_ref_id
 * @property string $header
 * @property string $footer
 * @property string $added_by
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property Event $eventRef
 */
class BaseEventInvitation extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EventInvitation the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'event_invitation';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('event_ref_id, added_by, added_on', 'required'),
			array('event_ref_id', 'numerical', 'integerOnly'=>true),
			array('added_by', 'length', 'max'=>10),
			array('header, footer', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('event_invitation_id, event_ref_id, header, footer, added_by, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'eventRef' => array(self::BELONGS_TO, 'Event', 'event_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'event_invitation_id' => 'Event Invitation',
			'event_ref_id' => 'Event Ref',
			'header' => 'Header',
			'footer' => 'Footer',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('event_invitation_id',$this->event_invitation_id);
		$criteria->compare('event_ref_id',$this->event_ref_id);
		$criteria->compare('header',$this->header,true);
		$criteria->compare('footer',$this->footer,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}